/*****************************************************************************
 * Project: SCT Application Example for LPC800
 *
 * Implements a start stop event example for the SCT 
 *
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal    Port               Signal      
 * -------------------------------------------------------------------------
 * CTOUT_0   P0_6   pin 18      COUNTER_L_RUN
 * CTOUT_1   P0_7   pin 17      COUNTER_H_RUN
 * CTOUT_2   P0_8   pin 14      STATE_1
 * CTOUT_3   P0_9   pin 13      STATE_2
 * ------------------------------------------------------------------------*/

#include "start_stop.h"

int main (void) 
{
    LPC_SWM->PINASSIGN6 = 0x06FFFFFF;          // CTOUT_0 at P0_6
    LPC_SWM->PINASSIGN7 = 0xFF090807;          // CTOUT_1 at P0_7, CTOUT_2 at P0_8 ,CTOUT_3 at P0_9

    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 8);     // enable the SCT clock
    start_stop_init();                         // initialize the SCT
    LPC_SCT->CTRL_U = (0  << 0)  |             // DOWN_L [0]     = L counting down
                      (0  << 1)  |             // STOP_L [1]     = L counter does run
                      (0  << 2)  |             // HALT_L [2]     = unhalt the L counter
                      (1  << 3)  |             // CLRT_L [3]     = clear L counter
                      (0  << 4)  |             // BIDIR_L[4]     = not bidirectional counting
                      (11 << 5)  |             // PRE_L  [12:5]  = L prescaler = 12
                      (0  << 16) |             // DOWN_H [16]    = H counting down
                      (1  << 17) |             // STOP_H [1]     = stop the H counter
                      (0  << 18) |             // HALT_H [2]     = unhalt the H counter
                      (1  << 19) |             // CLRT_H [3]     = clear H counter
                      (0  << 20) |             // BIDIR_H[4]     = not bidirectional counting
                      (11 << 21);              // PRE_H  [28:21] = H prescaler = 12
    
    while (1) 
    {
    }
}


